
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Aug 16 12:04:13 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_MAIN_SeP_SIM.c#1:csrc:1
   *  \author einatr
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */
/* disabling pc lint warning regarding Undefined preprocessor variable :
'DX_ARM_INTEGRATOR_DEBUG' Internal Dx value */
/*lint --e{553} */
/*disabling pc lint warning regarding Boolean within 'if'*/
/*lint --e{774} */
/*lint --e{522} */
#define _CRT_SECURE_NO_DEPRECATE /* To avoid Visual studio 2005 warnings*/
/************* Include Files ***********************************/
#ifdef SST_SEP_SIMULATOR_ENV
	#include "sst_native_duplicate_wrapper.h" 
#endif

#include "SST_TST.h"
#include "nvs_thread.h"
#include "DX_VOS_Time.h"
#include "sst_test_flags.h"
#include "DX_VOS_Thread.h"

#ifdef DX_ARM_INTEGRATOR_DEBUG
	#include "CRYS_INIT_TST.h"
#endif

/************************ Defines ******************************/
extern DxVosSem g_nvsSemaphore;
#ifdef NVS_LOG_PRINT
	DxVosFile g_nvsLogFile;
#endif
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
int            SST_TST_IsInteractive = 0;
char           *SST_TST_log_fname_ptr = DX_NULL;
DxError_t      TST_TestStatus,TST_ATP_Error;
DxError_t      TST_Error;
DxByte_t       TST_Workspace[TST_WORKSPACE_SIZE_BYTES];
DxUint32_t     TST_WorkspaceSizeInBytes = TST_WORKSPACE_SIZE_BYTES;
DxVosFile      TST_MainDBFileHandle;
DxVosFile      TST_SecondaryDBFileHandle;
SSTVersion_t   TST_Display_SST_version;
/************* Private function prototype **********************/
static void usage(char *pname);
static CRYSError_t SST_ATP_TST_SST_Acceptance_ALL_TESTS(void);
/************************ Public Functions *********************/

#if SST_SEP_SIM_TST

int main(int argc, char *argv[])

#else

DxError_t SST_SEP_SIM_TST_main (int argc, char *argv[])

#endif  /* SST_SEP_SIM_TST */
{

	FILE *TST_main_log_ptr = DX_NULL;

	DxVosThread threadHandle;
	DxBool_t    taskCompleted = DX_FALSE;
 
   /*Turn off VOS debug prints*/ 
	TST_ATP_Error = DX_VOS_DbgPrint_DisableModulePrinting(DX_DBG_ERROR_PROPAGATION|DX_DBG_MEM_ALLOC);
	/* VOS return code error 
	if (TST_ATP_Error != TESTPASS)
	return (CRYSError_t)TESTFAIL;*/

   /*Delete old DB file to start a new clean test*/
   DX_VOS_FDelete(SST_DB_FILENAME);

    /* Initialize Board clocks */
    /***************************/
    #ifdef DX_ARM_INTEGRATOR_DEBUG
		CRYS_TST_Init();
    #endif

	/* Init the NVS Host for work */
	/******************************/
	#ifdef NVS_LOG_PRINT
		DX_VOS_FOpen(&g_nvsLogFile,"NVS_LOG_FILE.txt","w+b");
	#endif
	DX_VOS_SemCreate(&g_nvsSemaphore,
					NVS_THREAD_SEMAPHORE_INIT_VALUE,
					NVS_THREAD_SEMAPHORE_NAME);
	DX_VOS_SemWait(g_nvsSemaphore, DX_INFINITE);
	DX_VOS_ThreadCreate(&threadHandle, 
						(DxThreadFunc)NVSThread_ProtocolFunction, 
						&taskCompleted,
						NVS_THREAD_THREAD_NAME,                     
						DX_VOS_PRIORITY_VERY_HIGH,  
						DX_NULL,                 /*Stack pointer of the thread. The stuck pointer
												 is only a recommendation for the OS.*/
												 0);                      /*Size of stack. If 0 the OS will use its default stack size.*/

	#ifdef NVS_LOG_PRINT
		DX_VOS_FPrintf(g_nvsLogFile,"%d: SEP FIRST TAKE \n",DX_VOS_GetTickCount());
		DX_VOS_FFlush(g_nvsLogFile);
	#endif

	/* Init the CRYS for work */
	/**************************/
    #ifdef DX_CRYS_MULTI_CPU_SUPPORT
	TST_ATP_Error = CRYS_Init(CRYS_COMMON_TST_CRYPT_LITE_BOARD_BASE_ADDR,
                              (DxUint8_t *)NULL,
                              CRYS_MULTI_CPU_CP_ID);
    #else
	TST_ATP_Error = CRYS_Init(CRYS_COMMON_TST_CRYPT_LITE_BOARD_BASE_ADDR,(DxUint8_t *)"DiscretixQA" , sizeof("DiscretixQA") );
    #endif
    TST_ATP_Error = TST_CheckErrorReturn(TST_ATP_Error,
                                         "CRYS_Init",
                                         "!!!!!!!!!",
                                         "!!!!!!!!!");
    if (TST_ATP_Error != TESTPASS)
        return (CRYSError_t)TESTFAIL;

   SST_VersionGet(&TST_Display_SST_version);

    switch (argc) {
    case 1:
        /* no options specified: interactive mode, logging to stdout */
        break;
    case 2:
        if (argv[1][0] == '-' && (argv[1][1] == 'b' || argv[1][1] == 'B'))
        SST_TST_IsInteractive = 1;
        else
        usage(argv[0]);
        break;
    case 3:
        if (argv[1][0] == '-' && (argv[1][1] == 'f' || argv[1][1] == 'F'))
        {
            SST_TST_log_fname_ptr = argv[2];
            TST_main_log_ptr = fopen(SST_TST_log_fname_ptr ,"w");
            if (TST_main_log_ptr == DX_NULL)
            {
                DX_VOS_Printf("CANT OPEN LOG FILE \n");
                return TESTFAIL;
            }
            fclose(TST_main_log_ptr);
        }
        else
        usage(argv[0]);
        break;
    case 4:
        if (argv[1][0] == '-' && (argv[1][1] == 'b' || argv[1][1] == 'B'))
        SST_TST_IsInteractive = 1;
        else
        usage(argv[0]);
        if (argv[2][0] == '-' && (argv[2][1] == 'f' || argv[2][1] == 'F'))
        {
            SST_TST_log_fname_ptr = argv[3];
            TST_main_log_ptr = fopen(SST_TST_log_fname_ptr ,"w");
            if (TST_main_log_ptr == DX_NULL)
            {
                DX_VOS_Printf("CANT OPEN LOG FILE \n");
                return TESTFAIL;
            }
            fclose(TST_main_log_ptr);
        }
        else
        usage(argv[0]);
        break;
    default:
        usage(argv[0]);
    }

	/*open files and get files handle*/
	TST_TestStatus = DX_VOS_FOpen(&TST_MainDBFileHandle,SST_DB_FILENAME ,"w+b");
	if (TST_TestStatus == DX_FAILURE)
	{
		DX_VOS_Printf("CANT OPEN MAIN FILE \n");
		return TESTFAIL;
	}

	TST_TestStatus = DX_VOS_FOpen(&TST_SecondaryDBFileHandle,SST_DB_FILENAME_SECOND ,"w+b");
	if (TST_TestStatus == DX_FAILURE)
	{
		DX_VOS_Printf("CANT OPEN SECONDARY FILE \n");
		return TESTFAIL;
	}

    if (SST_TST_IsInteractive == 1)
    {
		
		TST_Error = SST_Init((DxNvsMemoryId)TST_MainDBFileHandle,
							 (DxNvsMemoryId)TST_SecondaryDBFileHandle,
							 TST_Workspace,
							 TST_WorkspaceSizeInBytes);

		TST_TestStatus = TST_CheckErrorReturn(TST_Error,"SST_Init",
											  "",
											  "");
		#if SST_TST_EXIT_ON_ERROR
			if (TST_TestStatus != TESTPASS)
				return TESTFAIL;
		#endif
    }
    else
    {
	    DxInt_t  Var;

		TST_Error = SST_Init((DxNvsMemoryId)TST_MainDBFileHandle,
							(DxNvsMemoryId)TST_SecondaryDBFileHandle,
							 TST_Workspace,
							 TST_WorkspaceSizeInBytes);

		TST_TestStatus = TST_CheckErrorReturn(TST_Error,"SST_Init",
											  "",
											  "");
		#if SST_TST_EXIT_ON_ERROR
			if (TST_TestStatus != TESTPASS)
				return TESTFAIL;
		#endif

	    for(;;)
	    {
		    for(;;)
		    {
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n\n\n--[Main Menu - ATP tests ]----------------"));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [0] - Display SST Version                    "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n----------------------------------------------"));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [1] - Password Authenticator                 "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [2] - RSA Authenticator                      "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [3] - AES Key Authenticator                  "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [4] - ECC Key Authenticator                  "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [5] - Basic Data Operations                  "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [6] - Basic UnAuthnticated DataOperations    "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [7] - Binding & Writing Permissions          "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [8] - Special Data Operations AES            "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [9] - Special Data Operations DES            "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [a] - Special Data Operations HMAC           "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [b] - Special Data Operations RSA            "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [c] - Read Only Data                         "));                    
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [d] - Index Services                         "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [e] - Iterator Services                      "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [f] - Init/Terminate                         "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [g] - Transaction RollBack					"));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [T] - Run All ATP Tests                      "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [Z] - End Of Tests                           "));
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n-----------------------------------------------\n\n"));
                    Var = DX_VOS_GetCh();
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n Test = %c\n",Var));
		            if (Var<='z')
		                        break;
		            else
		            {
		                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
		            }
		     };

		        switch(Var)
		        {
                        case '0':
                                SST_ATP_TST_ShowSSTVersion();
                                break;
                        case '1':
                                SST_TST_ATP_PasswordAuthenticator();
                                break; 
                        case '2':
                                SST_TST_ATP_RsaAsymAuthenticator();
                                break; 
                        case '3':
                                SST_TST_ATP_AesKeyAsymAuthenticator();
                                break;
                        case '4':
                                SST_TST_ATP_ECCAsymAuthenticator();
                                break;
                        case '5':
                                SST_TST_ATP_BasicDataOp();
                                break;                              
                        case '6':
                                SST_TST_ATP_BasicUnAuthnticatedDataOp();
                                break;
                        case '7':
                                SST_TST_ATP_BindingWritingPermissions();
                                break;                           
                        case '8':
                                SST_TST_ATP_SpecialDataOpAES();
                                break;
                        case '9':
                                SST_TST_ATP_SpecialDataOpDES();
                                break;
                        case 'a':
                                SST_TST_ATP_SpecialDataOpHMAC();
                                break;
                        case 'b':
                                SST_TST_ATP_SpecialDataOpRSA();
                                break;
                        case 'c':
                                SST_TST_ATP_ReadOnlyData();
                                break;                                
                        case 'd':
                                SST_TST_ATP_Index();
                                break;
                        case 'e':
                                SST_TST_ATP_Iterator();
                                break;
                        case 'f':
                                SST_TST_ATP_InitTerminate();
                                break;
                        case 'g':
                                SST_TST_ATP_RollBack();
                                break;
                        case 'T':
                                SST_ATP_TST_SST_Acceptance_ALL_TESTS();
                                break;                            
                        case 'Z':
                                DX_VOS_Printf("\n End of SST tests \n");
                                break ;
                        default:
                            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n*** Error in test selection [%c]\n",Var));
		        }
		        if(Var =='Z')
		        break;
	        };
    }
	
	/*Finalize the NVS Semaphore*/
	/****************************/
	DX_VOS_SemGive(g_nvsSemaphore);	
	DX_VOS_SemDelete(g_nvsSemaphore);
	#ifdef NVS_LOG_PRINT
		DX_VOS_FPrintf(g_nvsLogFile,"%d: SEP END \n",DX_VOS_GetTickCount());
		DX_VOS_FClose(g_nvsLogFile);
	#endif		

	return TESTPASS;
 }/* End of SST_TST_main*/
/************************ Private Functions ******************************/
static void usage(char *pname)
{
  DX_VOS_Printf("Usage: %s [-b] [-f logfile]\n", pname);
  exit(-1);
}

/************************ Private Functions ******************************/
/*****************************************************************************
 * Function Name:                                                           
 * 	SST_ATP_TST_AES_Acceptance_ALL_TESTS 		
 * 
 * Inputs:
 * 	none 
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * This function runs all of the AES Acceptance tests
 *
 ******************************************************************************/
static CRYSError_t SST_ATP_TST_SST_Acceptance_ALL_TESTS(void)
{	
    DxError_t TST_ATP_SST_Error = TESTPASS;

    TST_ATP_Error = SST_TST_ATP_PasswordAuthenticator();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif

    TST_ATP_Error = SST_TST_ATP_RsaAsymAuthenticator();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif

    TST_ATP_Error = SST_TST_ATP_AesKeyAsymAuthenticator();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif

    TST_ATP_Error = SST_TST_ATP_ECCAsymAuthenticator();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
      
		
    TST_ATP_Error = SST_TST_ATP_BasicDataOp();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif


    TST_ATP_Error = SST_TST_ATP_BasicUnAuthnticatedDataOp();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif    

    TST_ATP_Error = SST_TST_ATP_BindingWritingPermissions();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif    

    TST_ATP_Error = SST_TST_ATP_SpecialDataOpAES();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif  
		
    TST_ATP_Error = SST_TST_ATP_SpecialDataOpDES();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
		        return 	TST_ATP_SST_Error;
    #endif  

        TST_ATP_Error = SST_TST_ATP_SpecialDataOpHMAC();
        TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
		        return 	TST_ATP_SST_Error;
    #endif 

    TST_ATP_Error = SST_TST_ATP_SpecialDataOpRSA();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
		        return 	TST_ATP_SST_Error;
    #endif 

    TST_ATP_Error = SST_TST_ATP_ReadOnlyData();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
		        return 	TST_ATP_SST_Error;
    #endif 

    TST_ATP_Error = SST_TST_ATP_Index();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
		        return 	TST_ATP_SST_Error;
    #endif 

    TST_ATP_Error = SST_TST_ATP_Iterator();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
		        return 	TST_ATP_SST_Error;
    #endif

    TST_ATP_Error = SST_TST_ATP_InitTerminate();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
		        return 	TST_ATP_SST_Error;
    #endif 

    TST_ATP_Error = SST_TST_ATP_RollBack();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_ATP_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
		        return 	TST_ATP_SST_Error;
    #endif
       

		/*Check if all tests pass*/
		if (TST_ATP_SST_Error != TESTPASS)
			{
				ATP_LOG_TST_PRINT((SST_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
				ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE SST TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
				ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
			}
			else
			{
				ATP_LOG_TST_PRINT((SST_TST_MSG,"\n \n******************************************************************\n"));
				ATP_LOG_TST_PRINT((SST_TST_MSG,"******************************************************************\n"));
				ATP_LOG_TST_PRINT((SST_TST_MSG,"********* ALL OF THE SST Acceptance TESTS PASS   :-)         *********\n"));
				ATP_LOG_TST_PRINT((SST_TST_MSG,"******************************************************************\n"));
				ATP_LOG_TST_PRINT((SST_TST_MSG,"******************************************************************\n"));						
			}	
		return TST_ATP_SST_Error;

}

